# ZapPlay TV Backend - PHP

Backend PHP pentru platforma IPTV ZapPlay TV.
Backend URL: `backendtv.zappnet.ro`

## Structură

```
backend web/tv/
├── api/
│   ├── playlist.php          # GET playlist M3U8
│   ├── channels.php          # GET lista canale
│   ├── channels/
│   │   └── search.php        # Căutare canale
│   ├── categories.php        # GET categorii
│   └── favorites.php         # GET/TOGGLE favorite
├── config/
│   └── database.php          # Configurare database
├── database/
│   └── create_tables.sql     # Schema database
├── .htaccess                 # Apache rewrite rules
└── README.md
```

## Setup

1. **Creează baza de date**:
   ```bash
   mysql -u root -p < database/create_tables.sql
   ```

2. **Configurează database.php**:
   - Editează `config/database.php` cu credențialele tale MySQL

3. **Configurează Apache**:
   - Asigură-te că mod_rewrite este activat
   - DocumentRoot trebuie să fie setat la directorul `backend web/tv/`

## API Endpoints

### POST /api/playlist
Obține playlist-ul M3U8 pentru un utilizator.

**Request:**
```json
{
  "user_id": 1,
  "token": "optional_token"
}
```

**Response:**
```json
{
  "success": true,
  "data": {
    "id": 1,
    "name": "Default Playlist",
    "url": "https://example.com/playlist.m3u8",
    "channels": [...],
    "categories": [...]
  }
}
```

### POST /api/channels
Obține lista de canale.

**Request:**
```json
{
  "category_id": 1,
  "search": "sports",
  "page": 1,
  "limit": 50,
  "user_id": 1
}
```

**Response:**
```json
{
  "success": true,
  "data": [
    {
      "id": 1,
      "name": "Channel 1",
      "url": "https://example.com/channel1.m3u8",
      "logo": "https://example.com/logo1.png",
      "category": "Entertainment",
      "is_favorite": 0
    }
  ]
}
```

### POST /api/categories
Obține lista de categorii.

**Request:**
```json
{
  "user_id": 1,
  "playlist_id": 1
}
```

**Response:**
```json
{
  "success": true,
  "data": [
    {
      "id": 1,
      "name": "Entertainment",
      "icon": "🎬",
      "channel_count": 10
    }
  ]
}
```

### POST /api/favorites
Obține canalele favorite.

**Request:**
```json
{
  "user_id": 1,
  "token": "optional_token"
}
```

### POST /api/favorites/toggle
Adaugă sau elimină un canal din favorite.

**Request:**
```json
{
  "channel_id": 1,
  "user_id": 1
}
```

**Response:**
```json
{
  "success": true,
  "data": true  // true = adăugat, false = eliminat
}
```

### POST /api/channels/search
Caută canale.

**Request:**
```json
{
  "search": "sports",
  "user_id": 1
}
```

## Database Schema

- **playlists** - Playlist-uri M3U8
- **categories** - Categorii de canale
- **channels** - Canale IPTV
- **favorites** - Canale favorite per utilizator

## Configurare

Editează `config/database.php` cu credențialele tale:

```php
private $host = 'localhost';
private $db_name = 'zapplay_tv';
private $username = 'root';
private $password = '';
```

## Deployment

1. Upload fișierele pe server
2. Configurează Apache virtual host
3. Creează baza de date
4. Actualizează credențialele în `config/database.php`

## Notă

Asigură-te că PHP are extensiile necesare:
- PDO
- PDO_MySQL
- mod_rewrite (pentru Apache)

