<?php
/**
 * API endpoint pentru obținerea listei de categorii
 * POST /api/categories
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$userId = $input['user_id'] ?? null;
$playlistId = $input['playlist_id'] ?? null;

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    // Dacă nu avem playlist_id, obținem primul playlist disponibil
    if (!$playlistId && $userId) {
        $playlistQuery = "
            SELECT id FROM playlists 
            WHERE user_id = :user_id OR user_id IS NULL
            ORDER BY user_id DESC, created_at DESC
            LIMIT 1
        ";
        $playlistStmt = $db->prepare($playlistQuery);
        $playlistStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
        $playlistStmt->execute();
        $playlist = $playlistStmt->fetch();
        $playlistId = $playlist['id'] ?? null;
    }
    
    $query = "
        SELECT 
            cat.id,
            cat.name,
            cat.icon,
            COUNT(c.id) as channel_count
        FROM categories cat
        LEFT JOIN channels c ON c.category_id = cat.id
        WHERE (cat.playlist_id = :playlist_id OR cat.playlist_id IS NULL)
        GROUP BY cat.id, cat.name, cat.icon
        ORDER BY cat.name ASC
    ";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(':playlist_id', $playlistId, PDO::PARAM_INT);
    $stmt->execute();
    
    $categories = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $categories
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

