<?php
/**
 * API endpoint pentru obținerea listei de canale
 * POST /api/channels
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$categoryId = $input['category_id'] ?? null;
$search = $input['search'] ?? null;
$page = isset($input['page']) ? (int)$input['page'] : 1;
$limit = isset($input['limit']) ? (int)$input['limit'] : 50;
$userId = $input['user_id'] ?? null;

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    $query = "
        SELECT 
            c.id,
            c.name,
            c.url,
            c.logo,
            c.category_id,
            cat.name as category,
            c.description,
            c.language,
            c.country,
            c.is_hd,
            c.epg_id,
            CASE WHEN f.id IS NOT NULL THEN 1 ELSE 0 END as is_favorite
        FROM channels c
        LEFT JOIN categories cat ON c.category_id = cat.id
        LEFT JOIN favorites f ON f.channel_id = c.id AND f.user_id = :user_id
        WHERE 1=1
    ";
    
    $params = [':user_id' => $userId];
    
    if ($categoryId) {
        $query .= " AND c.category_id = :category_id";
        $params[':category_id'] = $categoryId;
    }
    
    if ($search) {
        $query .= " AND (c.name LIKE :search OR c.description LIKE :search_desc)";
        $searchTerm = "%{$search}%";
        $params[':search'] = $searchTerm;
        $params[':search_desc'] = $searchTerm;
    }
    
    $query .= " ORDER BY c.name ASC";
    
    if ($limit > 0) {
        $offset = ($page - 1) * $limit;
        $query .= " LIMIT :limit OFFSET :offset";
        $params[':limit'] = $limit;
        $params[':offset'] = $offset;
    }
    
    $stmt = $db->prepare($query);
    
    foreach ($params as $key => $value) {
        if (is_int($value)) {
            $stmt->bindValue($key, $value, PDO::PARAM_INT);
        } else {
            $stmt->bindValue($key, $value, PDO::PARAM_STR);
        }
    }
    
    $stmt->execute();
    $channels = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $channels
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

