<?php
/**
 * API endpoint pentru gestionarea favoritelor
 * POST /api/favorites - obține favorite
 * POST /api/favorites/toggle - adaugă/elimină favorite
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    // Obține favorite
    $userId = $input['user_id'] ?? null;
    $token = $input['token'] ?? null;
    
    if (!$userId) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'user_id is required'
        ]);
        exit();
    }
    
    $query = "
        SELECT 
            c.id,
            c.name,
            c.url,
            c.logo,
            c.category_id,
            cat.name as category,
            c.description,
            c.language,
            c.country,
            c.is_hd,
            c.epg_id,
            1 as is_favorite
        FROM favorites f
        INNER JOIN channels c ON f.channel_id = c.id
        LEFT JOIN categories cat ON c.category_id = cat.id
        WHERE f.user_id = :user_id
        ORDER BY f.created_at DESC
    ";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $stmt->execute();
    
    $favorites = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $favorites
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

