<?php
/**
 * API endpoint pentru toggle favorite
 * POST /api/favorites/toggle
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit();
}

$input = json_decode(file_get_contents('php://input'), true);
$channelId = $input['channel_id'] ?? null;
$userId = $input['user_id'] ?? null;

if (!$channelId || !$userId) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'channel_id and user_id are required'
    ]);
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    if (!$db) {
        throw new Exception('Database connection failed');
    }
    
    // Verifică dacă există deja
    $checkQuery = "
        SELECT id FROM favorites 
        WHERE channel_id = :channel_id AND user_id = :user_id
    ";
    $checkStmt = $db->prepare($checkQuery);
    $checkStmt->bindParam(':channel_id', $channelId, PDO::PARAM_INT);
    $checkStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
    $checkStmt->execute();
    $existing = $checkStmt->fetch();
    
    if ($existing) {
        // Elimină din favorite
        $deleteQuery = "
            DELETE FROM favorites 
            WHERE channel_id = :channel_id AND user_id = :user_id
        ";
        $deleteStmt = $db->prepare($deleteQuery);
        $deleteStmt->bindParam(':channel_id', $channelId, PDO::PARAM_INT);
        $deleteStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
        $deleteStmt->execute();
        
        echo json_encode([
            'success' => true,
            'data' => false
        ]);
    } else {
        // Adaugă în favorite
        $insertQuery = "
            INSERT INTO favorites (channel_id, user_id, created_at)
            VALUES (:channel_id, :user_id, NOW())
        ";
        $insertStmt = $db->prepare($insertQuery);
        $insertStmt->bindParam(':channel_id', $channelId, PDO::PARAM_INT);
        $insertStmt->bindParam(':user_id', $userId, PDO::PARAM_INT);
        $insertStmt->execute();
        
        echo json_encode([
            'success' => true,
            'data' => true
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Server error: ' . $e->getMessage()
    ]);
}

